/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.lpar;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspVioScsiConfig;
import com.ibm.hsc.fsp.cmdhelpers.VioSlotState;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.lpar.OmLparVethUpdater;
import com.ibm.hsc.objmgr.lpar.OmLparVserialUpdater;
import com.ibm.hsc.objmgr.lpar.OmLparVsmcaUpdater;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class OmLparVscsiUpdater {
    private OmLparMgr mLparMgr;
    private OmCecMgr mCecMgr;
    private RObject mLparObj;
    private RObjectId mLparOid;
    private int updateFlag = 0;
    private FspCmdHelper mCmdHelper;
    private FSPCmdMgr mCmdMgr;

    public OmLparVscsiUpdater(OmLparMgr omLparMgr) {
        this.mLparMgr = omLparMgr;
        this.mLparObj = this.mLparMgr.getObject();
        this.mLparOid = this.mLparMgr.getObjectId();
        this.mCecMgr = this.mLparMgr.getCecMgr();
        this.mCmdHelper = this.mCecMgr.getCmdHelper();
        this.mCmdMgr = this.mCecMgr.getCmdMgr();
    }

    public void update(Hashtable hashtable) throws RException, PIHscServerException, PIHscCmdMgrException {
        Object object;
        Object object2;
        RObject rObject;
        Object object3;
        Object object4;
        Enumeration<Object> enumeration;
        System.out.println("vscsiHash = " + hashtable);
        Vector vector = this.mLparObj.associators(R50Define.AID_IBMHSC_LparVirtualSCSI);
        System.out.println("vscsiObjVec = " + vector);
        if (vector != null) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object4 = (RObject)enumeration.nextElement();
                object3 = (String)((RObject)object4).getProperty("Name");
                rObject = new UnsignedInt16((String)object3);
                object2 = (VioSlotState)hashtable.get(rObject);
                if (object2 == null) {
                    this.deleteVscsi((RObject)object4);
                    continue;
                }
                object = this.mCmdHelper.getVirtualScsiSerialConfig(new UnsignedInt16(this.mLparMgr.getLparIndex()), (UnsignedInt16)rObject);
                if (this.updateVscsiInstance((RObject)object4, (FspVioScsiConfig)object, (VioSlotState)object2)) {
                    // empty if block
                }
                hashtable.remove(rObject);
            }
        }
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object4 = (VioSlotState)enumeration.nextElement();
            object3 = ((VioSlotState)object4).slotNumber;
            rObject = OmLparVscsiUpdater.getSameSlotNum(object3, this.mLparMgr.getLparName());
            if (rObject != null) {
                OmLparVscsiUpdater.deleteVslotWithDiffType(rObject, this.mLparMgr);
                continue;
            }
            object2 = new RObjectId(1, R50Define.CID_IBMHSC_VirtualSCSI);
            ((RObjectId)object2).setKeyValue(0, "IBMHSC_VirtualSCSI");
            ((RObjectId)object2).setKeyValue(1, ((VioSlotState)object4).slotNumber.toString());
            ((RObjectId)object2).setKeyValue(2, "IBMHSC_Partition");
            ((RObjectId)object2).setKeyValue(3, this.mLparMgr.getLparName());
            object = new RObject((RObjectId)object2);
            ((RObject)object).addInstance();
            ((RObject)object).addAssociation(R50Define.AID_IBMHSC_LparVirtualSCSI, this.mLparOid);
            FspVioScsiConfig fspVioScsiConfig = this.mCmdHelper.getVirtualScsiSerialConfig(new UnsignedInt16(this.mLparMgr.getLparIndex()), ((VioSlotState)object4).slotNumber);
            System.out.println("lpar id = " + this.mLparMgr.getLparName() + "virtual slot = " + ((VioSlotState)object4).slotNumber + " verscsiConfig = " + fspVioScsiConfig);
            this.updateVscsiInstance((RObject)object, fspVioScsiConfig, (VioSlotState)object4);
        }
        System.out.println("client table = " + this.mCecMgr.getClientAdaptersTable());
        System.out.println("server table = " + this.mCecMgr.getServerAdaptersTable());
        System.out.println("incompatible client table = " + this.mCecMgr.getIncompatibleClients());
    }

    private boolean updateVscsiInstance(RObject rObject, FspVioScsiConfig fspVioScsiConfig, VioSlotState vioSlotState) throws RException {
        String string;
        int n;
        boolean bl = false;
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)rObject.getProperty("DeviceAttribute");
        int n2 = n = fspVioScsiConfig.getVirtDeviceAttr().intValue();
        if (unsignedInt8 != null) {
            n2 = unsignedInt8.intValue();
        }
        String string2 = (String)rObject.getProperty("Name");
        if (n2 == 1) {
            if (n == n2) {
                if (this.updateVscsiProperties(rObject, fspVioScsiConfig, vioSlotState)) {
                    bl = true;
                }
                return this.updateVscsiToClientAssoc(rObject, fspVioScsiConfig) || bl;
            }
            return this.convertVscsiServToClient(rObject, fspVioScsiConfig, vioSlotState);
        }
        if (n == n2) {
            if (this.updateVscsiProperties(rObject, fspVioScsiConfig, vioSlotState)) {
                bl = true;
            }
            return this.updateVscsiToServAssoc(rObject, fspVioScsiConfig) || bl;
        }
        String string3 = String.valueOf(this.mLparMgr.getLparIndex());
        string3 = string3 + "*" + string2;
        Hashtable hashtable = this.mCecMgr.getClientAdaptersTable();
        Hashtable hashtable2 = this.mCecMgr.getServerAdaptersTable();
        Vector vector = (Vector)hashtable2.get(string = (String)hashtable.get(string3));
        if (vector != null) {
            vector.remove(string3);
        }
        rObject.deleteAssociationsByLink(222);
        Hashtable hashtable3 = this.mCecMgr.getIncompatibleClients();
        hashtable3.remove(string3);
        this.updateVscsiProperties(rObject, fspVioScsiConfig, vioSlotState);
        this.updateVscsiToClientAssoc(rObject, fspVioScsiConfig);
        return true;
    }

    private boolean updateVscsiProperties(RObject rObject, FspVioScsiConfig fspVioScsiConfig, VioSlotState vioSlotState) throws RException {
        UnsignedInt8 unsignedInt8 = fspVioScsiConfig.getVirtDeviceAttr();
        UnsignedInt8 unsignedInt82 = fspVioScsiConfig.getSupportHmcClient();
        boolean bl = false;
        if (rObject.setProperty("DeviceAttribute", (Object)unsignedInt8)) {
            bl = true;
        }
        if (rObject.setProperty("SupportHMC", (Object)unsignedInt82)) {
            bl = true;
        }
        if (rObject.setProperty("Required", (Object)new Boolean(fspVioScsiConfig.isRequired()))) {
            bl = true;
        }
        if (rObject.setProperty("DrcIndex", (Object)fspVioScsiConfig.getDrcIndex())) {
            bl = true;
        }
        if (rObject.setProperty("DrcName", (Object)fspVioScsiConfig.getDrcName())) {
            bl = true;
        }
        if (rObject.setProperty("RemoteLparID", (Object)fspVioScsiConfig.getServerLparId())) {
            bl = true;
        }
        if (rObject.setProperty("RemoteSlotID", (Object)fspVioScsiConfig.getServerVirtSlotNum())) {
            bl = true;
        }
        if (rObject.setProperty("CurLockOwnerClass", (Object)vioSlotState.curLockOwnerClass)) {
            bl = true;
        }
        if (rObject.setProperty("CurLockOwnerId", (Object)vioSlotState.currentSlotLockOwner)) {
            bl = true;
        }
        if (rObject.setProperty("PendLockOwnerClass", (Object)vioSlotState.pendLockOwnerClass)) {
            bl = true;
        }
        if (rObject.setProperty("PendLockOwnerId", (Object)vioSlotState.pendingSlotLockOwner)) {
            bl = true;
        }
        return bl;
    }

    private boolean updateVscsiToServAssoc(RObject rObject, FspVioScsiConfig fspVioScsiConfig) throws RException {
        Cloneable cloneable;
        Vector vector;
        int n;
        boolean bl = false;
        String string = this.mCecMgr.getCecName();
        UnsignedInt16 unsignedInt16 = fspVioScsiConfig.getServerLparId();
        UnsignedInt16 unsignedInt162 = fspVioScsiConfig.getServerVirtSlotNum();
        String string2 = (String)rObject.getProperty("Name");
        String string3 = String.valueOf(this.mLparMgr.getLparIndex());
        string3 = string3 + "*" + string2;
        Hashtable hashtable = this.mCecMgr.getClientAdaptersTable();
        String string4 = (String)hashtable.get(string3);
        String string5 = unsignedInt16.toString() + "*" + unsignedInt162.toString();
        String string6 = null;
        String string7 = null;
        if (string4 != null && string4.length() > 0) {
            n = string4.indexOf(42);
            string6 = string4.substring(0, n);
            string7 = string4.substring(n + 1);
            if (Integer.parseInt(string6) == unsignedInt16.intValue() && Integer.parseInt(string7) == unsignedInt162.intValue()) {
                return false;
            }
        }
        n = 0;
        if (string4 != null && string4.length() > 0) {
            n = OmLparVscsiUpdater.isCompatible(rObject, unsignedInt16.toString(), unsignedInt162.toString(), this.mCecMgr, this.mLparMgr) ? 1 : 0;
        }
        hashtable.put(string3, string5);
        Hashtable hashtable2 = this.mCecMgr.getServerAdaptersTable();
        if (string4 != null && string4.length() > 0) {
            vector = (Vector)hashtable2.get(string4);
            if (vector != null) {
                vector.remove(string3);
            }
            cloneable = rObject.associatorsByLink(222);
            rObject.deleteAssociationsByLink(222);
            if (cloneable != null && ((Vector)cloneable).size() > 0) {
                bl = true;
            }
        }
        if ((vector = (Vector)hashtable2.get(string5)) == null) {
            vector = new Vector();
        }
        vector.add(string3);
        hashtable2.put(string5, vector);
        cloneable = this.mCecMgr.getIncompatibleClients();
        if (n != 0) {
            ((Hashtable)cloneable).remove(string3);
            RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_VirtualSCSI);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualSCSI");
            rObjectId.setKeyValue(1, unsignedInt162);
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, unsignedInt16 + "*" + string);
            rObject.addAssociationByLink(222, rObjectId);
            bl = true;
        } else {
            ((Hashtable)cloneable).put(string3, string5);
        }
        return bl;
    }

    private boolean updateVscsiToClientAssoc(RObject rObject, FspVioScsiConfig fspVioScsiConfig) throws RException {
        boolean bl = false;
        String string = this.mCecMgr.getCecName();
        Hashtable hashtable = this.mCecMgr.getServerAdaptersTable();
        String string2 = (String)rObject.getProperty("Name");
        String string3 = String.valueOf(this.mLparMgr.getLparIndex());
        Vector vector = (Vector)hashtable.get(string3 = string3 + "*" + string2);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            Hashtable hashtable2 = this.mCecMgr.getIncompatibleClients();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                int n = string4.indexOf(42);
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                RObject rObject2 = OmLparVscsiUpdater.getSameSlotNum(new UnsignedInt16(string6), string5 + "*" + string);
                RObjectId rObjectId = null;
                boolean bl2 = false;
                if (rObject2 != null) {
                    bl2 = OmLparVscsiUpdater.isCompatible(rObject, string5, string6, this.mCecMgr, this.mLparMgr);
                    rObjectId = rObject2.getObjectId();
                }
                if (bl2) {
                    hashtable2.remove(string4);
                    if (rObject.hasAssociationByLink(221, rObjectId)) continue;
                    rObject.addAssociationByLink(221, rObjectId);
                    bl = true;
                    continue;
                }
                hashtable2.put(string4, string3);
                if (rObjectId == null || !rObject.hasAssociationByLink(221, rObjectId)) continue;
                rObject.deleteAssociationByLink(221, rObjectId);
                bl = true;
            }
        } else {
            Vector vector2 = rObject.associatorsByLink(221);
            rObject.deleteAssociationsByLink(221);
            if (vector2 != null && vector2.size() > 0) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isCompatible(RObject rObject, String string, String string2, OmCecMgr omCecMgr, OmLparMgr omLparMgr) throws RException {
        System.out.println("isCompatible - serverObj=" + rObject);
        System.out.println("isCompatible - lparId=" + string + " slotId=" + string2);
        String string3 = (String)rObject.getProperty("CreationClassName");
        String string4 = omCecMgr.getCecName();
        if (string3.equals("IBMHSC_VirtualSerial")) {
            UnsignedInt8 unsignedInt8;
            RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_VirtualSerial);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualSerial");
            rObjectId.setKeyValue(1, string2);
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, string + "*" + string4);
            System.out.println("vserialOid = " + rObjectId);
            RObject rObject2 = rObjectId.getObject();
            if (rObject2 == null) {
                System.out.println("vserial  not existing. isCompatible=flase");
                return false;
            }
            UnsignedInt8 unsignedInt82 = (UnsignedInt8)rObject.getProperty("DeviceAttribute");
            if (unsignedInt82.equals((Object)(unsignedInt8 = (UnsignedInt8)rObject2.getProperty("DeviceAttribute")))) {
                return false;
            }
            if (unsignedInt82.intValue() == 1) {
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)rObject.getProperty("RemoteLparID");
                UnsignedInt16 unsignedInt162 = (UnsignedInt16)rObject.getProperty("RemoteSlotID");
                int n = 65535;
                int n2 = 65535;
                if (unsignedInt16 != null) {
                    n = unsignedInt16.intValue();
                }
                if (unsignedInt162 != null) {
                    n2 = unsignedInt162.intValue();
                }
                return n == 65535 || n == Integer.parseInt(string) || n2 == 65535 || n2 == Integer.parseInt(string2);
            }
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)rObject2.getProperty("RemoteLparID");
            UnsignedInt16 unsignedInt163 = (UnsignedInt16)rObject2.getProperty("RemoteSlotID");
            int n = 65535;
            int n3 = 65535;
            if (unsignedInt16 != null) {
                n = unsignedInt16.intValue();
            }
            if (unsignedInt163 != null) {
                n3 = unsignedInt163.intValue();
            }
            return n == 65535 || n == omLparMgr.getLparIndex() || n3 == 65535 || n3 == Integer.parseInt((String)rObject.getProperty("Name"));
        }
        if (string3.equals("IBMHSC_VirtualSCSI")) {
            UnsignedInt8 unsignedInt8;
            RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_VirtualSCSI);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualSCSI");
            rObjectId.setKeyValue(1, string2);
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, string + "*" + string4);
            RObject rObject3 = rObjectId.getObject();
            if (rObject3 == null) {
                System.out.println("vscsi not existing. isCompatible=flase");
                return false;
            }
            UnsignedInt8 unsignedInt83 = (UnsignedInt8)rObject.getProperty("DeviceAttribute");
            if (unsignedInt83.equals((Object)(unsignedInt8 = (UnsignedInt8)rObject3.getProperty("DeviceAttribute")))) {
                return false;
            }
            if (unsignedInt83.intValue() == 1) {
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)rObject.getProperty("RemoteLparID");
                UnsignedInt16 unsignedInt164 = (UnsignedInt16)rObject.getProperty("RemoteSlotID");
                int n = 65535;
                int n4 = 65535;
                if (unsignedInt16 != null) {
                    n = unsignedInt16.intValue();
                }
                if (unsignedInt164 != null) {
                    n4 = unsignedInt164.intValue();
                }
                return n == 65535 || n == Integer.parseInt(string) || n4 == 65535 || n4 == Integer.parseInt(string2);
            }
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)rObject3.getProperty("RemoteLparID");
            UnsignedInt16 unsignedInt165 = (UnsignedInt16)rObject3.getProperty("RemoteSlotID");
            int n = 65535;
            int n5 = 65535;
            if (unsignedInt16 != null) {
                n = unsignedInt16.intValue();
            }
            if (unsignedInt165 != null) {
                n5 = unsignedInt165.intValue();
            }
            return n == 65535 || n == omLparMgr.getLparIndex() || n5 == 65535 || n5 == Integer.parseInt((String)rObject.getProperty("Name"));
        }
        return false;
    }

    public static RObject getSameSlotNum(UnsignedInt16 unsignedInt16, String string) throws RException {
        RObjectId rObjectId;
        boolean bl = false;
        RObject rObject = null;
        if (rObject == null) {
            rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_VirtualSerial);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualSCSI");
            rObjectId.setKeyValue(1, unsignedInt16.toString());
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, string);
            rObject = rObjectId.getObject();
        }
        if (rObject == null) {
            rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_VirtualSCSI);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualSCSI");
            rObjectId.setKeyValue(1, unsignedInt16.toString());
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, string);
            rObject = rObjectId.getObject();
        }
        if (rObject == null) {
            rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_VirtualEthernet);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualEthernet");
            rObjectId.setKeyValue(1, unsignedInt16.toString());
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, string);
            rObject = rObjectId.getObject();
        }
        if (rObject == null) {
            rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_VirtualSMCA);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualSMCA");
            rObjectId.setKeyValue(1, unsignedInt16.toString());
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, string);
            rObject = rObjectId.getObject();
        }
        System.out.println("vslotObj=" + rObject);
        return rObject;
    }

    public static void deleteVslotWithDiffType(RObject rObject, OmLparMgr omLparMgr) throws RException {
        String string = (String)rObject.getProperty("CreationClassName");
        String string2 = (String)rObject.getProperty("SystemName");
        String string3 = string2.substring(0, string2.indexOf(42));
        String string4 = (String)rObject.getProperty("Name");
        String string5 = string3 + "*" + string4;
        if (string.equalsIgnoreCase("IBMHSC_VirtualEthernet")) {
            OmLparVethUpdater omLparVethUpdater = new OmLparVethUpdater(omLparMgr);
            omLparVethUpdater.deleteVeth(rObject);
        } else if (string.equalsIgnoreCase("IBMHSC_VirtualSerial")) {
            OmLparVserialUpdater omLparVserialUpdater = new OmLparVserialUpdater(omLparMgr);
            omLparVserialUpdater.deleteVserial(rObject);
        } else if (string.equalsIgnoreCase("IBMHSC_VirtualSCSI")) {
            OmLparVscsiUpdater omLparVscsiUpdater = new OmLparVscsiUpdater(omLparMgr);
            omLparVscsiUpdater.deleteVscsi(rObject);
        } else if (string.equalsIgnoreCase("IBMHSC_VirtualSMCA")) {
            OmLparVsmcaUpdater omLparVsmcaUpdater = new OmLparVsmcaUpdater(omLparMgr);
            omLparVsmcaUpdater.deleteVsmca(rObject);
        }
    }

    public void deleteVscsi(RObject rObject) throws RException {
        if (rObject != null) {
            String string = (String)rObject.getProperty("SystemName");
            String string2 = string.substring(0, string.indexOf(42));
            String string3 = (String)rObject.getProperty("Name");
            String string4 = string2 + "*" + string3;
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)rObject.getProperty("DeviceAttribute");
            if (unsignedInt8.intValue() == 0) {
                Hashtable hashtable;
                Hashtable hashtable2 = this.mCecMgr.getClientAdaptersTable();
                String string5 = (String)hashtable2.get(string4);
                if (string5 != null) {
                    hashtable = this.mCecMgr.getServerAdaptersTable();
                    Vector vector = (Vector)hashtable.get(string5);
                    vector.remove(string4);
                }
                hashtable2.remove(string4);
                hashtable = this.mCecMgr.getIncompatibleClients();
                hashtable.remove(string4);
            } else {
                Hashtable hashtable = this.mCecMgr.getServerAdaptersTable();
                Vector vector = (Vector)hashtable.get(string4);
                if (vector != null) {
                    Enumeration enumeration = vector.elements();
                    Hashtable hashtable3 = this.mCecMgr.getIncompatibleClients();
                    while (enumeration.hasMoreElements()) {
                        String string6 = (String)enumeration.nextElement();
                        hashtable3.put(string6, string4);
                    }
                }
            }
            rObject.deleteInstance();
        }
    }

    private boolean convertVscsiServToClient(RObject rObject, FspVioScsiConfig fspVioScsiConfig, VioSlotState vioSlotState) throws RException {
        Cloneable cloneable;
        boolean bl = false;
        String string = (String)rObject.getProperty("Name");
        Hashtable hashtable = this.mCecMgr.getServerAdaptersTable();
        String string2 = String.valueOf(this.mLparMgr.getLparIndex());
        Vector vector = (Vector)hashtable.get(string2 = string2 + "*" + string);
        if (vector != null) {
            cloneable = this.mCecMgr.getIncompatibleClients();
            for (int i = 0; i < vector.size(); ++i) {
                ((Hashtable)cloneable).put(vector.elementAt(i), string2);
            }
        }
        cloneable = rObject.associatorsByLink(222);
        rObject.deleteAssociationsByLink(222);
        if (cloneable != null && ((Vector)cloneable).size() > 0) {
            bl = true;
        }
        if (this.updateVscsiProperties(rObject, fspVioScsiConfig, vioSlotState)) {
            bl = true;
        }
        if (this.updateVscsiToServAssoc(rObject, fspVioScsiConfig)) {
            bl = true;
        }
        return bl;
    }

    private boolean convertVscsiClientToServ(RObject rObject, FspVioScsiConfig fspVioScsiConfig, VioSlotState vioSlotState) throws RException {
        Cloneable cloneable;
        String string;
        boolean bl = false;
        String string2 = (String)rObject.getProperty("Name");
        String string3 = String.valueOf(this.mLparMgr.getLparIndex());
        string3 = string3 + "*" + string2;
        Hashtable hashtable = this.mCecMgr.getClientAdaptersTable();
        Hashtable hashtable2 = this.mCecMgr.getServerAdaptersTable();
        Vector vector = (Vector)hashtable2.get(string = (String)hashtable.get(string3));
        if (vector != null) {
            vector.remove(string3);
            cloneable = rObject.associatorsByLink(222);
            rObject.deleteAssociationsByLink(222);
            if (cloneable != null && ((Vector)cloneable).size() > 0) {
                bl = true;
            }
        }
        cloneable = this.mCecMgr.getIncompatibleClients();
        ((Hashtable)cloneable).remove(string3);
        if (this.updateVscsiProperties(rObject, fspVioScsiConfig, vioSlotState)) {
            bl = true;
        }
        if (this.updateVscsiToClientAssoc(rObject, fspVioScsiConfig)) {
            bl = true;
        }
        return bl;
    }
}

